/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.mixin;

import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import questsadditions.mixinutils.IMixinQuest;
import questsadditions.rewards.Repeatable;

@Mixin(value={TeamData.class})
public abstract class MixinTeamData {
    @Inject(method={"claimReward(Lnet/minecraft/server/level/ServerPlayer;Ldev/ftb/mods/ftbquests/quest/reward/Reward;Z)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Ldev/ftb/mods/ftbquests/quest/reward/Reward;claim(Lnet/minecraft/server/level/ServerPlayer;Z)V")}, cancellable=true, remap=false)
    private void claimReward(ServerPlayer player, Reward reward, boolean notify, CallbackInfo cir) {
        if (reward instanceof Repeatable) {
            cir.cancel();
        }
    }

    @Inject(method={"canStartTasks(Ldev/ftb/mods/ftbquests/quest/Quest;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void canStartTasks(Quest quest, CallbackInfoReturnable<Boolean> cir) {
        List<QuestObject> incompatible = ((IMixinQuest)quest).getIncompatibleQuests();
        if (!incompatible.isEmpty()) {
            for (QuestObject object : incompatible) {
                if (object.invalid || !((TeamData)this).isCompleted(object)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }
}

